DROP DATABASE IF EXISTS hara;
CREATE DATABASE IF NOT EXISTS hara;
USE hara;

DROP TABLE IF EXISTS Race;
DROP TABLE IF EXISTS Chevaux;
DROP TABLE IF EXISTS App;
DROP TABLE IF EXISTS Proprietaire;

CREATE TABLE IF NOT EXISTS Race(
    krace INT NOT NULL AUTO_INCREMENT,
    libelle VARCHAR(255) NOT NULL,
    PRIMARY KEY(krace)
);

CREATE TABLE IF NOT EXISTS Chevaux(
    kCheval INT NOT NULL AUTO_INCREMENT,
    nomCheval VARCHAR(40) NOT NULL,
    prenomCheval VARCHAR(40) NOT NULL,
    fkrace INT NOT NULL,
    PRIMARY KEY(kCheval)
);

CREATE TABLE IF NOT EXISTS App(
    fkCheval INT NOT NUll,
    fkProprio INT NOT NULL,
    taux FLOAT NOT NULL,
    PRIMARY KEY(fkCheval,fkProprio)
);

CREATE TABLE IF NOT EXISTS Proprietaire(
    kProprio INT NOT NULL AUTO_INCREMENT,
    nom VARCHAR(20) NOT NULL,
    prenom VARCHAR(20) NOT NULL,
    PRIMARY KEY(kProprio)
);

ALTER TABLE `Chevaux` ADD FOREIGN KEY (`fkrace`) REFERENCES `Race`(`krace`)ON DELETE CASCADE ON UPDATE CASCADE;
ALTER TABLE `App` ADD FOREIGN KEY (`fkCheval`) REFERENCES `Chevaux`(`kCheval`)ON DELETE CASCADE ON UPDATE CASCADE;
ALTER TABLE `App` ADD FOREIGN KEY (`fkProprio`) REFERENCES `Proprietaire`(`kProprio`)ON DELETE CASCADE ON UPDATE CASCADE;

INSERT INTO `Race`(`libelle`) VALUES("etalon");
INSERT INTO `Race`(`libelle`) VALUES("poney");
INSERT INTO `Race`(`libelle`) VALUES("petitponey");


INSERT INTO `Chevaux`(`nomCheval`,`prenomCheval`,`fkrace`)VALUES("petit","tonerre",3);
INSERT INTO `Chevaux`(`nomCheval`,`prenomCheval`,`fkrace`)VALUES("coca","cola",1);
INSERT INTO `Chevaux`(`nomCheval`,`prenomCheval`,`fkrace`)VALUES("eclair","chocolat",2);

INSERT INTO `Proprietaire`(`nom`,`prenom`)VALUES("nyai","mathilde");
INSERT INTO `Proprietaire`(`nom`,`prenom`)VALUES("nyai","jeremy");
INSERT INTO `Proprietaire`(`nom`,`prenom`)VALUES("nyai","pauline");
INSERT INTO `Proprietaire`(`nom`,`prenom`)VALUES("nyai","louisa");
INSERT INTO `Proprietaire`(`nom`,`prenom`)VALUES("simon","arnaud");
