DROP DATABASE IF EXISTS Bloc1_tp;
CREATE DATABASE IF NOT EXISTS Bloc1_tp;
USE Bloc1_tp;

CREATE TABLE IF NOT EXISTS pieces;
CREATE TABLE IF NOT EXISTS capteurs;
CREATE TABLE IF NOT EXISTS mesures;


CREATE TABLE pieces(
    `kpiece`INT NOT NULL AUTO_INCREMENT,
    `nomPiece` VARCHAR(50) NOT NULL,
    `dateMajPiece` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`kpiece`)
);


CREATE TABLE capteurs(
    `kcapteur`INT NOT NULL AUTO_INCREMENT,
    `nomCapteur` VARCHAR(50) NOT NULL,
    `unite` VARCHAR(20),
    `commentaire` VARCHAR(255) DEFAULT NULL,
    `dateMajCapteur`DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `fkpiece`INT NOT NULL,
    PRIMARY KEY (`kcapteur`)
)
ENGINE = InnoDB;

CREATE TABLE mesures(
    `kmesure` INT NOT NULL AUTO_INCREMENT,
    `dateMesure` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `dateMajMesure` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `fkcapteur` INT NOT NULL,
    PRIMARY KEY(`kmesure`)
)
ENGINE = InnoDB;

ALTER TABLE `capteurs` ADD FOREIGN KEY (`fkpiece`) REFERENCES `pieces`(`kpiece`);
ALTER TABLE `mesures` ADD FOREIGN KEY (`fkcapteur`) REFERENCES `capteurs`(`kcapteur`);

INSERT INTO `pieces`(`nomPiece`) VALUES ("chambre");
INSERT INTO `pieces`(`nomPiece`) VALUES ("cuisine");
INSERT INTO `pieces`(`nomPiece`) VALUES ("salle de bain");
INSERT INTO `pieces`(`nomPiece`) VALUES ("bureau");


INSERT INTO `capteurs`(`nomcapteur`,`unite`,`fkpiece`) VALUES ("anenometre","metres",1);
INSERT INTO `capteurs`(`nomcapteur`,`unite`,`fkpiece`) VALUES ("thermometre","degres",1);

INSERT INTO `capteurs`(`nomcapteur`,`unite`,`fkpiece`) VALUES ("barometre","pascal",2);
INSERT INTO `capteurs`(`nomcapteur`,`unite`,`fkpiece`) VALUES ("thermometre","degres",2);

INSERT INTO `capteurs`(`nomcapteur`,`unite`,`fkpiece`) VALUES ("thermometre","degres",3);
INSERT INTO `capteurs`(`nomcapteur`,`unite`,`fkpiece`) VALUES ("hydrometre","/100",3);

INSERT INTO `capteurs`(`nomcapteur`,`unite`,`fkpiece`) VALUES ("thermometre","degres",4);
INSERT INTO `capteurs`(`nomcapteur`,`unite`,`fkpiece`) VALUES ("luxometre","lux",4);


